// Step 4 page JavaScript
document.addEventListener('DOMContentLoaded', function() {
    console.log('AED Step 4 page loaded successfully');
    
    // Get the AED device element (image 5)
    const aedDevice = document.querySelector('.aed-device');
    
    // Get the connection indicator (rectangle 8)
    const connectionIndicator = document.querySelector('.connection-indicator');
    
    // Make the AED device draggable
    makeDraggable(aedDevice);
    
    function makeDraggable(element) {
        let isDragging = false;
        let currentX;
        let currentY;
        let initialX;
        let initialY;
        let xOffset = 0;
        let yOffset = 0;
        
        // Mouse events
        element.addEventListener('mousedown', dragStart);
        document.addEventListener('mousemove', drag);
        document.addEventListener('mouseup', dragEnd);
        
        // Touch events for mobile
        element.addEventListener('touchstart', dragStart);
        document.addEventListener('touchmove', drag);
        document.addEventListener('touchend', dragEnd);
        
        function dragStart(e) {
            if (e.type === 'touchstart') {
                initialX = e.touches[0].clientX - xOffset;
                initialY = e.touches[0].clientY - yOffset;
            } else {
                initialX = e.clientX - xOffset;
                initialY = e.clientY - yOffset;
            }
            
            if (e.target === element || element.contains(e.target)) {
                isDragging = true;
                element.style.cursor = 'grabbing';
            }
        }
        
        function drag(e) {
            if (isDragging) {
                e.preventDefault();
                
                if (e.type === 'touchmove') {
                    currentX = e.touches[0].clientX - initialX;
                    currentY = e.touches[0].clientY - initialY;
                } else {
                    currentX = e.clientX - initialX;
                    currentY = e.clientY - initialY;
                }
                
                xOffset = currentX;
                yOffset = currentY;
                
                setTranslate(currentX, currentY, element);
                
                // Check collision during drag
                checkCollision();
            }
        }
        
        function dragEnd(e) {
            if (isDragging) {
                initialX = currentX;
                initialY = currentY;
                isDragging = false;
                element.style.cursor = 'grab';
                
                // Final collision check
                checkCollision();
            }
        }
        
        function setTranslate(xPos, yPos, el) {
            el.style.transform = `translate3d(${xPos}px, ${yPos}px, 0)`;
        }
        
        // Set initial cursor
        element.style.cursor = 'grab';
    }
    
    function checkCollision() {
        const aedRect = aedDevice.getBoundingClientRect();
        const targetRect = connectionIndicator.getBoundingClientRect();
        
        // Check if the AED device overlaps with the connection indicator
        const isColliding = !(
            aedRect.right < targetRect.left ||
            aedRect.left > targetRect.right ||
            aedRect.bottom < targetRect.top ||
            aedRect.top > targetRect.bottom
        );
        
        if (isColliding) {
            console.log('AED device connected! Navigating to next step...');
            // Navigate to the next step
            window.location.href = 'step4-complete.html';
        }
    }
});
